@extends('layouts.admin')
@section('title')
    Rotary • Club of Lekki Phase One
@endsection

@section('styles')

@endsection

@section('page')
<a href="{{url('/members')}}">Members</a>
@endsection


@section('content')
	
			<section class="ls section_padding_top_50 section_padding_bottom_50 columns_padding_5">
				<div class="container-fluid">

					<div class="row">
						<div class="col-sm-12">
							<h3>Club 
								<small>Members</small>
							</h3>
							<span class="pull-right">
											<a href="{{url('/addmembers')}}" class="theme_button small_button">Add Member</a>
										</span>
						</div>
					</div>
					<!-- .row -->

					<div class="row">
						<div class="col-sm-12">
							<div class="with_border with_padding">



								<!-- <h3 class="divider_40">Bootstrap Stripped Table</h3> -->
								<div class="table-responsive">

								<table class="table table-striped table-bordered">
									<thead>
										<tr>
											<th>#</th>
											<th>Name</th>
											<th>Email</th>
											<th>Office</th>	
											<th>Facebook Handle</th>
											<th>Twitter Handle</th>	
											<th>Biodata</th>
											<th>Actions</th>
										</tr>
									</thead>
									<?php $i=1;?>
									<tbody>
										   @foreach ($members as $m)
										<tr>
											<td>{{$i++}}</td>
											<td>{{$m['name']}}</td>
											<td>{{$m['email']}}</td>
											<td>{{$m['office']}}</td>
											<td>{{$m['facebook']}}</td>
											<td>{{$m['twitter']}}</td>
											<td>
												<?php
													 $yourString =$m['bio'];
												  if (strlen($yourString) > 100){
				                                    $maxLength = 99;
				                                    $yourString = substr($yourString, 0, $maxLength);
				                                    $yourString= $yourString.'...';
				                                    echo $yourString;

				                                }else{
				                                     echo $yourString;
				                                }

											?>

											</td>
											<td>
												<!-- <a class="theme_button small_button" href="{{url('/viewmembers')}}/{{$m['sn']}}">View Member</a> -->
												<a href="{{url('/editmembers')}}/{{$m['sn']}}" class="theme_button small_button">Edit Member</a>
												<!-- <a href="{{url('/disablemembers')}}/{{$m['sn']}}" class="theme_button small_button">Disable Member</a> -->
												<?php if($m['active'] == 1 ){ ?>
													<button  class="theme_button small_button" id="disbutton" value="{{$m['sn']}}" >Disable Member</button>
											   <?php }else{ ?>
											    	<button  class="theme_button small_button" id="enbutton" value="{{$m['sn']}}">Enable Member</button>
											    <?php } ?>
												
												
												<a href="{{url('/memberphoto')}}/{{$m['sn']}}" class="theme_button small_button">Upload Photo</a>
												
											</td>
										</tr>
										    @endforeach
									</tbody>

								</table>
							</div>

							{!! $members->render() !!} 
							</div>
							<!-- .with_border -->

						</div>
						<!-- .col-* -->
					</div>
					<!-- .row -->


					<!-- .row -->

				</div>
				<!-- .container -->
			</section>

@endsection



@section('script')
<script src="../js/joseadebag.js"></script>
@endsection
